function status() {
	jqueryUI();
	submit_ajax();
	load_modelname("status");

	$("#cpe_customer").change(function (e) {
		var customer = $('#cpe_customer').val();
		get_status(customer);
		$.cookie("customer", e.target.value);
	});

	$("#log_date").change(function (e) {
		var customer = $('#cpe_customer').val();
		update_log(true, customer);
	});

	$("#status_filter").change(function (e) {
		var customer = $('#cpe_customer').val();
		filter_log(customer);
	});

	$(document).unbind("load_modelname_complete_event");
	$(document).bind("load_modelname_complete_event", function (e, status) {
		var selected = $('#cpe_customer');
		var cookie_customer = $.cookie('customer');
		if (cookie_customer) {
			selected.val(cookie_customer);
		}
		var customer = $('#cpe_customer').val();
		get_status(customer);
	});
}

var All_ary = [];
var Success_ary = [];
var Fail_ary = [];
var UpToDate_ary = [];
var Upgrading_ary = [];
var umniah_item	= ["Time", "Serial", "MAC", "FwV", "Status"];
var gemtek_item	= ["Time", "IMEI", "IMSI", "MSISDN", "SERIAL", "HW_VER", "SW_VER", "CELL", "LAC", "RSSI", "RSRP", "SINR", "RSCP", "ECIO", "METHOD", "BAND", "ACTION"];
var status_item = {'umniah' : umniah_item, 'gemtek' : gemtek_item, 'mobily' : gemtek_item, 'gp' : gemtek_item, 'pixela' : gemtek_item};

function get_status(customer) {
	$('#status_tbl .ui-widget' ).hide();
	var timeStamp = Math.floor(Date.now());
	$.post(
		model_path + "status.php?customer=" + customer + "&time=" + timeStamp,
		function (data) {
			$('#status_tbl .' + customer).show();
			var len = create_date_option(data);
			document.getElementById('log_date').disabled = len ? 0 : true;
			document.getElementById('status_filter').disabled = (len && customer == "umniah") ? 0 : true;
			document.getElementById('log_date').selectedIndex = len ? Number(len) - 1 : 0;
			document.getElementById('status_filter').value = "all";
			update_log(true, customer);
		}
	);
}
function create_array(logdata, customer) {
	All_ary = [], Success_ary = [], Fail_ary = [], UpToDate_ary = [], Upgrading_ary = [];
	var Data_Array = logdata.split("\n");
	var i, max;
	for(i=0, max=Data_Array.length-1; i<max; i++)
	{
		var tmpArray = Data_Array[i].split(";");
		var newobj = {};
		for (var j=0; j<status_item[customer].length; j++) {
			newobj[status_item[customer][j]] = tmpArray[j];
		}
		All_ary.push(newobj);
		if ((newobj.Status == "SUCCESS") || (newobj.STATUS == "Success")) {
			Success_ary.push(newobj);
		}
		else if ((newobj.Status == "FAILED") || (newobj.STATUS == "Failure")){
			Fail_ary.push(newobj);
		}
		else if (newobj.STATUS == "UpToDate") {
			UpToDate_ary.push(newobj);
		}
		else if (newobj.STATUS == "Upgrading") {
			Upgrading_ary.push(newobj);
		}
	}
}

function update_log(if_refresh_table, customer) {
	var filename = document.getElementById('log_date').value;
	var xmlhttp = new XMLHttpRequest();
	xmlhttp.onreadystatechange = function () {
		if (xmlhttp.readyState == 4 && xmlhttp.status == 200) {
			create_array(xmlhttp.responseText, customer);
			if (if_refresh_table)
				filter_log(customer);
		}
	}
	xmlhttp.open("GET", "web/system/controller/getlog.php?filename=" + filename, true);
	xmlhttp.send();
}

function filter_log(customer) {
	var filter = document.getElementById('status_filter').value;
	if (filter == "all") {
		refresh_table(All_ary, customer);
	}
	else if (filter == "success") {
		refresh_table(Success_ary, customer);
	}
	else if (filter == "fail") {
		refresh_table(Fail_ary, customer);
	}
	else if (filter == "up2date") {
		refresh_table(UpToDate_ary, customer);
	}
	else if (filter == "upgrading") {
		refresh_table(Upgrading_ary, customer);
	}
	else {
		alert("Filter log error!");
	}
}

function refresh_table(ary, customer) {
	var tbl;
	if (customer == 'umniah')
		tbl = document.getElementById('umniah_tbl');
	else
		tbl = document.getElementById('gemtek_tbl');
	var i, j, max;

	for(i=1, max=tbl.rows.length; i<max; i++) {
		tbl.deleteRow(max - i);
	}

	for(i=0, max=ary.length; i<max; i++) {
		row = tbl.insertRow(i+1);
		for (var j=0; j<status_item[customer].length; j++)
			row.insertCell(j).appendChild(document.createTextNode(ary[i][status_item[customer][j]]));
	}
}

function create_date_option(data) {
	$("#log_date").html('');
	var obj = JSON.parse(data);
	var len = obj.row.length;
	for (var i=0; i<len; i++) {
		var row = obj.row[i];
		var path = row.path;
		var filename = row.filename
		$("#log_date").append('<option value=' + path + '>' + filename + '</option>');
	}
	return len;
}

function link_filename(id) {
	$("#cssmenu a").eq(0).click();
	$.cookie("currentPageIndex", 3);
	$.cookie("frompage", "filename");
	window.location.replace("index.php" + id);
}
