function upgrade() {
	jqueryUI();
	submit_ajax();
	load_modelname("upgrade");
	load_serverip("upgrade");

	$("#cpe_customer").change(function (e) {
		jQuery("#filename_table").jqGrid('setGridParam', {
			url : model_path + "search_upload_file.php?" + $("#firmware_form").serialize(),
			page : 1
		}).trigger("reloadGrid");
		$.cookie("customer", e.target.value);
	});

	$("#serverip").change(function (e) {
		$.cookie("serverip", e.target.value);
	});

	$("#apply").click(function (e) {
		e.preventDefault();
		var str=$("#file").val().split(".");
		if ((str[str.length-1] != "ipk") && (str[str.length-1] != "zip") && (str[str.length-1] != "bin")) {
			alert("Please upload a ipk/bin or full.zip file!");
			return false;
		}

		$( "#dialog" ).dialog("open");
		$("#file").empty();
		$("#file").upload(controller_path + 'upload.php?' + $("#firmware_form").serialize(), function (data) {
			$( "#dialog" ).dialog("close");

			if (data != "Success") {
				alert(data);
			} else {
				jQuery("#filename_table").jqGrid('setGridParam', {
					url : model_path + "search_upload_file.php?" + $("#firmware_form").serialize(),
					page : 1
				}).trigger("reloadGrid");
			}
		});
	})

	$(document).unbind("load_serverip_complete_event");
	$(document).bind("load_serverip_complete_event", function (e, status) {
		var cookie_serverip = $.cookie('serverip');
		if (cookie_serverip) {
			$('#serverip').val(cookie_serverip);
		}
	});
	$(document).unbind("load_modelname_complete_event");
	$(document).bind("load_modelname_complete_event", function (e, status) {
		var cookie_customer = $.cookie('customer');
		if (cookie_customer) {
			$('#cpe_customer').val(cookie_customer);
		}

		var cookie_serverip = $.cookie('serverip');
		if (cookie_serverip) {
			$('#serverip').val(cookie_serverip);
		}
		jQuery("#filename_table").jqGrid({
			url : model_path + "search_upload_file.php?" + $("#firmware_form").serialize(),
			datatype : "json",
			height : "auto",
			sortname: 'date',
			rowNum : 10,
			rowList : [10, 20, 30],
			pager : "#filename_list",
			colNames : ['Inv No', 'Date', 'Firmware Name', 'Release'],
			colModel : [
				{name : 'id', index : 'id', hidden : true},
				{name : 'date', index : 'date', width : 150, sortable : true, align : 'center'},
				{name : 'filename', index : 'filename', width : 400, sortable : true},
				{name : 'validate', index : 'validate', width : 60, align : 'center',
					sortable : false, edittype : 'checkbox', editoptions : {value: "1:0" },
					formatter : function cboxFormatter(cellvalue, options, rowObject)
					{
						return '<input type="checkbox"' + (cellvalue ? ' checked="checked"' : '')
							//+ ($('#cpe_customer').val()=="yota" ? ' disabled="disabled"' : '')
							+ ' onclick="cbox_validate_Event(\''
							+ rowObject.filename + '\',\''+cellvalue+'\')"/>';
					}
				}
			],
			multiselect : true,
			hoverrows : false
		});

		jQuery("#filename_table")
		.navGrid('#filename_list', {
			edit : false,
			add : false,
			del : false,
			search : false,
			refresh : false
		})
		.navButtonAdd('#filename_list', {
			caption : "",
			buttonicon : "ui-icon-trash",
			onClickButton : function () {
				var rowData;
				var list = jQuery("#filename_table").jqGrid('getGridParam', 'selarrrow');
				var ids = jQuery("#filename_table").jqGrid('getDataIDs');
				var files = [];
				for (var i = 0; i < ids.length; i++) {
					for (var j = 0; j < list.length; j++) {
						if (ids[i] == list[j]) {
							rowData = jQuery('#filename_table').jqGrid('getRowData', i);
							files.push(rowData.filename);
						}
					}
				}

				if (confirm("Are you sure to remove 【" + files + "】?"))
				{
					var timeStamp = Math.floor(Date.now());
					$.post(controller_path + "remove_file.php?" + $("#firmware_form").serialize() + "&time=" + timeStamp,{
						filename : files,
						path : "../../../firmware/" + $('#cpe_customer').val() + "/FW/"
					}, function () {
						jQuery("#filename_table").trigger('reloadGrid');
					})
				}
			},
			position : "last"
		});
	});
}

function cbox_validate_Event(val, check)
{
	if (check == 0) {
		if (confirm("Are you sure to release 【" + val + "】?"))
		{
			var timeStamp = Math.floor(Date.now());
			$.post(controller_path + 'make_use_file.php' + '?time=' + timeStamp, {
				use_dir	: "../../../firmware/fw_use/" + $('#cpe_customer').val() + "/",
				fw_dir	: "../../../firmware/" + $('#cpe_customer').val() + "/FW/",
				customer: $('#cpe_customer').val(),
				'filename' : val,
				'serverip' : $('#serverip').val()
			}, function(data) {
				$('#filename_table').trigger( 'reloadGrid' );
			})
		}
	} else {
		var timeStamp = Math.floor(Date.now());
		$.post(controller_path + 'remove_use_file.php' + '?time=' + timeStamp, {
			'filename' : val,
			path : "../../../firmware/fw_use/" + $('#cpe_customer').val() + "/",
			'customer' : $('#cpe_customer').val()
		}, function(data) {
			$('#filename_table').trigger( 'reloadGrid' );
		})
	}
}

function link_filename(id) {
	$("#cssmenu a").eq(0).click();
	$.cookie("currentPageIndex", 0);
	$.cookie("frompage", "filename");
	window.location.replace("index.php" + id);
}
