<?php
class find_files
{
	private $path;
	private $history;

	function __construct($get_path, $get_use_path, $get_history)
	{
		$this->path=$get_path;
		$this->use_path=$get_use_path;
		$this->history=$get_history;
	}

	public function get_files()
	{
		if (file_exists($this->path)) {
			$path = $this->path;
		} else {
			$path = "../".$this->path;
		}
		return $all_files = $this->find_all_files($path);
	}

	private function find_all_files($dir)
	{
		if (!is_dir($dir)) {
			return false;
		}

		$root = scandir($dir);
		if ($root != NULL) {
			foreach($root as $value)
			{
				if ($value === '.' || $value === '..') {
					continue;
				}
				if (is_file("$dir/$value")) {
					$ext = pathinfo($value, PATHINFO_EXTENSION);
					if (($ext === 'ipk') || ($ext === 'bin'))
						$result[] = "$dir$value";
					continue;
				}
				if ($this->find_all_files("$dir/$value") != NULL) {
					foreach($this->find_all_files("$dir/$value") as $value)
					{
						$result[] = $value;
					}
				}
			}
		}

		return $result;
	}

	public function search_upload_file()
	{
		$cell = $this->get_files();
		if (empty($cell)) {
			return false;
		}

		foreach($cell as $key => $value)
		{
			$path_parts = pathinfo($value);

			if (($path_parts['extension'] === 'ipk') || ($path_parts['extension'] === 'bin')) {
				$schedule[] = array(
					'id' => $key,
					'filename' => $path_parts['basename'],
					'date' => date("m/d/Y H:i:s", filemtime($value)),
					'validate' => $this->check_use_file($value)
				);
			}
		}
		return $schedule;
	}

	public function limit_search($cell, $start, $end, $sidx, $sord)
	{
		if (!empty($sidx))
		{
			foreach ($cell as $key => $values) {
				$timestamps[$key] = ($sidx == type) ? $values[$sidx] : strtotime($values[$sidx]);
			}

			$sord_name = array('asc'=>SORT_ASC, 'desc'=>SORT_DESC);
			array_multisort($timestamps, $sord_name[$sord], $cell);

			foreach ($cell as $key => $values) {
				$cell[$key][id] = $key;
			}
		}

		for ($i = $start; $i < $end; $i++) {
			if((isset($cell[$i])) && ($cell[$i] != NULL)) {
				$search[] = $cell[$i];
			}
		}
		return $search;
	}

	private function replace_PHP_EOL($str)
	{
		if (strtoupper(substr(PHP_OS, 0, 3) == 'WIN')) {
			$eol = "\r\n";
		} elseif (strtoupper(substr(PHP_OS, 0, 3) == 'MAC')) {
			$eol = "\r";
		} else {
			$eol = "\n";
		}
		$version = str_replace($eol, "", $str);

		return $version;
	}

	private function format_date($str)
	{
		if (empty($str)) {
			return "";
		} else {
			$new_date = date("m/d/Y H:i:s", mktime(substr($str, 8, 2), substr($str, 10, 2), substr($str, 12, 2), substr($str, 4, 2), substr($str, 6, 2), substr($str, 0, 4)));
			return $new_date;
		}
	}

	private function check_use_file($path)
	{
		$path_parts = pathinfo($path);
		$use_file = $this->use_path.$path_parts['filename'].'.use';
		if (file_exists($use_file)) {
			return 1;
		} else {
			return 0;
		}
	}
}
?>
