<?php
class jsonRPCClient {
	/**
	 * Debug state
	 *
	 * @var boolean
	 */
	private $debug;

	/**
	 * The server URL
	 *
	 * @var string
	 */
	private $url;
	/**
	 * The request id
	 *
	 * @var integer
	 */
	private $id;
	/**
	 * If true, notifications are performed instead of requests
	 *
	 * @var boolean
	 */
	private $notification = false;

	/**
	 * Takes the connection parameters
	 *
	 * @param string $url
	 * @param boolean $debug
	 */
	public function __construct($url,$debug = false) {
		$this->url = $url;
		empty($proxy) ? $this->proxy = '' : $this->proxy = $proxy;
		empty($debug) ? $this->debug = false : $this->debug = true;
		$this->id = 1;
	}

	/**
	 * Sets the notification state of the object. In this state, notifications are performed, instead of requests.
	 *
	 * @param boolean $notification
	 */
	public function setRPCNotification($notification) {
		empty($notification) ? $this->notification = false : $this->notification = true;
	}

	/**
	 * Performs a jsonRCP request and gets the results as an array
	 *
	 * @param string $method
	 * @param array $params
	 * @return array
	 */

	private $auth = "";
	public function call_auth($method,$params,$auth) {
		$this->auth = $auth;
		return $this->__call($method,$params);
	}

	public function __call($method,$params) {
		if (!is_scalar($method)) {
			throw new Exception('Method name has no scalar value');
		}

		if (is_array($params)) {
		} else {
			throw new Exception('Params must be given as array');
		}

		if ($this->notification) {
			$currentId = NULL;
		} else {
			$currentId = $this->id;
		}

		$request = array(
			'jsonrpc' => '2.0',
			'method' => $method,
			'params' => $params,
			'id' => $currentId
		);
		if (strlen($this->auth) > 0) {
			$request['auth']=$this->auth;
		}
		$request = json_encode($request);
		$this->debug && $this->debug.='***** Request *****'."\n".$request."\n".'***** End Of request *****'."\n\n";

		$opts = array ('http' => array (
			'jsonrpc' => '2.0',
			'method'  => 'POST',
			'header'  => 'Content-type: application/json',
			'content' => $request
		));
		$context  = stream_context_create($opts);
		if ($fp = fopen($this->url, 'r', false, $context)) {
			$response = '';
			while($row = fgets($fp)) {
				$response.= trim($row)."\n";
			}
			$this->debug && $this->debug.='***** Server response *****'."\n".$response.'***** End of server response *****'."\n";
			$response = json_decode($response,true);
		} else {
			throw new Exception('Unable to connect to '.$this->url);
		}

		if ($this->debug) {
			echo nl2br($debug);
		}
		if (!$this->notification) {
			if ($response['id'] != $currentId) {
				return "Incorrect response id";
			}
			if (!empty($response['error'])) {
				return $response['error'];
			}

			return $response['result'];

		} else {
			return true;
		}
	}
}
?>
