function settings() {
	jqueryUI();
	submit_ajax();
	load_modelname("settings");

	var gemtek_server_list	= ["Version", "ImageFileName", "RedirectURL", "ImageHash"];
	var huawei_server_list	= ["FOTAServerURL", "FirmwarePath", "VersionID", "FirmwareStatus","Forcedupdate"];
	var umniah_server_list	= ["UmniahVersion", "UmniahFileName"];
	var yota_server_list	= ["YotaVersion", "YotaServerURL"];
	var setting_server_list= {
		'huawei': huawei_server_list,
		'gemtek': gemtek_server_list,
		'umniah': umniah_server_list,
		'yota': yota_server_list
	};

	var gemtek_ui_list	= ["UI_URL"];
	var umniah_ui_list	= ["UmniahURL", "UmniahPackage"];
	var yota_ui_list	= ["YotaURL"];
	var setting_ui_list= {
		'gemtek': gemtek_ui_list,
		'huawei': gemtek_ui_list,
		'umniah': umniah_ui_list,
		'yota': yota_ui_list
	};

	var cpe_customer = $("#cpe_customer");

	cpe_customer.change(function (e) {
		$('#server_settings_form .cell').hide();
		$('#device_settings_form .cell').hide();

		var customer_value = $('#cpe_customer').val();
		var timeStamp = Math.floor(Date.now());
		$.post("firmware/" + customer_value + "/conf.json?time=" + timeStamp, function(data) {
			for (var i=0; i<setting_server_list[customer_value].length; i++) {
				$("#" + setting_server_list[customer_value][i]).val(data[setting_server_list[customer_value][i]]);
			}
			for (var i=0; i<setting_ui_list[customer_value].length; i++) {
				$("#" + setting_ui_list[customer_value][i]).val(data[setting_ui_list[customer_value][i]]);
			}
		})

		for (var i=0; i<setting_server_list[$('#cpe_customer').val()].length; i++) {
			$('#' + setting_server_list[$('#cpe_customer').val()][i]).parent().show();
		}

		for (var i=0; i<setting_ui_list[$('#cpe_customer').val()].length; i++) {
			$('#' + setting_ui_list[$('#cpe_customer').val()][i]).parent().show();
		}

		$.cookie("customer", e.target.value);
	});

	$(document).unbind("load_modelname_complete_event").bind('load_modelname_complete_event', function () {
		var selected = $('#cpe_customer');
		var cookie_customer = $.cookie('customer');
		if (cookie_customer) {
			selected.val(cookie_customer);
		}
		$('#cpe_customer').trigger('change');
	});

	$("#device_settings_form").validate({
		rules : {
			UI_URL			:{required:true, url:true},
			UmniahURL		:{required:true, url:true},
			UmniahPackage		:{required:true},
			YotaURL			:{required:true, url:true}
		},
	});

	$("#server_settings_form").validate({
		rules : {
			Version			:{required:true},
			ImageFileName		:{required:true},
			RedirectURL		:{required:true, url:true},
			FOTAServerURL		:{required:true},
			FirmwarePath		:{required:true},
			VersionID		:{required:true, digits:true},
			FirmwareStatus		:{required:true},
			Forcedupdate		:{required:true},
			UmniahVersion		:{required:true},
			UmniahFileName		:{required:true},
			YotaVersion		:{required:true},
			YotaServerURL		:{required:true, url:true}
		},
		submitHandler : function (form) {
			var timeStamp = Math.floor(Date.now());
			$.post(
				model_path + "settings.php?customer=" + $('#cpe_customer').val() + '&time=' + timeStamp,
				$("#server_settings_form").serialize() + '&' + $("#device_settings_form").serialize(),
				function (data) {console.log(data)}
			);
		}
	});
}
