<?php
function configure_package($customer, $url, $fver, $fname, $fmd5, $fsize, $fstatus, $fupdate) {
	$packages_file = "../../../firmware/".$customer."/Packages";
	$config_file = "../../../firmware/".$customer."/conf.json";
	$rurl = $url."light_ota/".$customer."/";
	if ($customer == "gemtek") {
		// Packages
		$content  = "ServerVersion=".$fver."\n";
		$content .= "ImageFileName=FW/".$fname."\n";
		$content .= "RedirectPKGURL=".$rurl."\n";
		$content .= "ImageHash=".$fmd5."\n";
		$content .= "AutoReboot=1\n";
		file_put_contents($packages_file.".tmp", $content);
		rename($packages_file.".tmp", $packages_file);

		// conf.json
		$content  = "{\"Version\":\"".$fver."\",";
		$content .= "\"ImageFileName\":\"".$fname."\",";
		$content .= "\"RedirectURL\":\"".$rurl."\",";
		$content .= "\"UI_URL\":\"".$rurl."Packages\",";
		$content .= "\"ImageHash\":\"".$fmd5."\"}";
		file_put_contents($config_file.".tmp", $content);
		rename($config_file.".tmp", $config_file);
	} else if ($customer == "huawei") {
		// filelist.xml
		$filelist_path = "../../../firmware/huawei/FW/filelist.xml";
		$content  = "<?xml version=\"1.0\" encoding=\"utf-8\"?>\n";
		$content .= "<root>\n<component>\n";
		$content .= "	<name>".$fver."</name>\n";
		$content .= "	<compress>0</compress>\n";
		$content .= "</component>\n<files>\n<file>\n";
		$content .= "	<spath>".$fname."</spath>\n";
		$content .= "	<dpath>".$fname."</dpath>\n";
		$content .= "	<operation>c</operation>\n";
		$content .= "	<md5>".$fmd5."</md5>\n";
		$content .= "	<size>".$fsize."</size>\n";
		$content .= "</file>\n</files>\n</root>";
		file_put_contents($filelist_path.".tmp", $content);
		rename($filelist_path.".tmp", $filelist_path);

		// conf.json
		$content  = "{\"FOTAServerURL\":\"".$url."\",";
		$content .= "\"FirmwarePath\":\"light_ota/westerneurope/files/r2091/f2/\",";
		$content .= "\"VersionID\":\"2091\",";
		$content .= "\"FirmwareStatus\":\"".$fstatus."\",";
		$content .= "\"Forcedupdate\":\"".$fupdate."\",";
		$content .= "\"UI_URL\":\"".$url."light_ota/westerneurope/\"}";
		file_put_contents($config_file.".tmp", $content);
		rename($config_file.".tmp", $config_file);

		// CheckNewVersion.aspx
		$pack_json = "../../../firmware/huawei/UrlCommand/CheckNewVersion.aspx";
		$content  = "<?xml version=\"1.0\" encoding=\"utf-8\"?>\n";
		$content .= "<status>".$fstatus."</status><forcedupdate>".$fupdate."</forcedupdate><versionID>2091</versionID><url>".$url."light_ota/westerneurope/files/r2091/f2/</url>";
		file_put_contents($pack_json.".tmp", $content);
		rename($pack_json.".tmp", $pack_json);

		// Check.action
		$pack_xml = "../../../firmware/huawei/v2/Check.action";
		$content  = "{\n";
		$content .= " \"status\": \"".$fstatus."\",\n";
		$content .= " \"forcedupdate\": \"".$fupdate."\",\n";
		$content .= " \"components\": [{\n";
		$content .= "  \"versionID\": \"2091\",\n";
		$content .= "  \"description\": \"xxx\",\n";
		$content .= "  \"url\": \"".$url."light_ota/westerneurope/files/r2091/f2/\"\n";
		$content .= " }]\n";
		$content .= "}";
		file_put_contents($pack_xml.".tmp", $content);
		rename($pack_xml.".tmp", $pack_xml);
	} else if ($customer == "umniah") {
		// Packages
		$content  = "ServerVersion=".$fver."\n";
		$content .= "ImageFileName=FW/".$fname."\n";
		file_put_contents($packages_file.".tmp", $content);
		rename($packages_file.".tmp", $packages_file);

		// conf.json
		$content  = "{\n\"UmniahVersion\":\"".$fver."\",";
		$content .= "\"UmniahFileName\":\"".$fname."\",\n";
		$content .= "\"UmniahURL\":\"".$rurl."\",\n";
		$content .= "\"UmniahPackage\":\"Packages\"\n}";
		file_put_contents($config_file.".tmp", $content);
		rename($config_file.".tmp", $config_file);
	} else if ($customer == "yota") {
		// Packages
		$content  = "Package: KERNEL\n";
		$content .= "Version: ".$fver."\n";
		$content .= "URL: ".$rurl."FW/".$fname."\n";
		$content .= "Filename: ".$fname."\n";
		$content .= "Size: ".$fsize."\n";
		$content .= "MD5Sum: ".$fmd5."\n";
		$content .= "Description: Auto installation image\n";
		file_put_contents($packages_file.".tmp", $content);
		rename($packages_file.".tmp", $packages_file);

		// conf.json
		$content  = "{\n\"YotaVersion\":\"".$fver."\",\n";
		$content .= "\"YotaServerURL\":\"".$rurl."FW/".$fname."\",\n";
		$content .= "\"YotaURL\":\"".$rurl."Packages\"\n}";
		file_put_contents($config_file.".tmp", $content);
		rename($config_file.".tmp", $config_file);
	}
}
?>
