<?php
$string = file_get_contents("../../config/model.json");
$json_a = json_decode($string, true);
foreach ($json_a[0]['CUSTOMER'] as $field => $value) {
	$customer = strtolower($value);
	init_fw_dir($customer);
	init_fw_use($customer);
	init_conf($customer);
}

function init_fw_dir($customer) {
	$fw_path = "../../../firmware/".$customer."/FW/";
	if(!file_exists($fw_path)) {
		mkdir($fw_path, 0777, TRUE);
	}
}

function init_fw_use($customer) {
	$use_dir="../../../firmware/fw_use/".$customer;
	if(!file_exists($use_dir)) {
		mkdir($use_dir, 0777, TRUE);
	}
}

function init_conf($customer) {
	if ($customer == "huawei") {
		$back_conf = "../../../firmware/huawei/default/Check.action";
		$dist_conf = "../../../firmware/huawei/v2/Check.action";
		if(!file_exists($dist_conf)) {
			copy($back_conf, $dist_conf);
		}

		$back_conf = "../../../firmware/huawei/default/CheckNewVersion.aspx";
		$dist_conf = "../../../firmware/huawei/UrlCommand/CheckNewVersion.aspx";
		if(!file_exists($dist_conf)) {
			copy($back_conf, $dist_conf);
		}

		$back_conf = "../../../firmware/huawei/default/conf.json";
		$dist_conf = "../../../firmware/huawei/conf.json";
		if(!file_exists($dist_conf)) {
			copy($back_conf, $dist_conf);
		}

		$back_conf = "../../../firmware/huawei/default/filelist.xml";
		$dist_conf = "../../../firmware/huawei/FW/filelist.xml";
		if(!file_exists($dist_conf)) {
			copy($back_conf, $dist_conf);
		}
	} else {
		$files = array_slice(scandir("../../../firmware/".$customer."/default"), 2);
		foreach ($files as $field => $file) {
			$back_conf="../../../firmware/".$customer."/default/".$file;
			$dist_conf="../../../firmware/".$customer."/".$file;
			if(!file_exists($dist_conf)) {
				copy($back_conf, $dist_conf);
			}
		}
	}
}
?>
