<?php
require("../controller/init.php");
$domain = $_POST['domain'];
if (is_null($domain)) {
	echo "Failed to change domain: Invalid input";
} else {
	fix_conf($domain);
	fix_packages($domain);
}

function fix_conf($domain)
{
	$dir = "../../config";
	find_all_files($dir, "json", $domain);
}

function fix_packages($domain)
{
	$dir = "../../../firmware";
	find_all_files($dir, "Packages", $domain);
	find_all_files($dir, "CheckNewVersion.aspx", $domain);
	find_all_files($dir, "Check.action", $domain);
}

function find_all_files($dir, $name, $domain)
{
	$root = scandir($dir);
	if ($root != NULL) {
		foreach($root as $value)
		{
			if ($value === '.' || $value === '..') {
				continue;
			}
			if (is_file("$dir/$value")) {
				$ext = pathinfo($value, PATHINFO_EXTENSION);
				if (($value === $name) || ($ext === "json")) {
					file_preg_replace("http://[0-9]{1,3}.[0-9]{1,3}.[0-9]{1,3}.[0-9]{1,3}[:]{0,1}[0-9]{0,5}", "http://".$domain, $dir."/".$value);
				}
				continue;
			}
			find_all_files("$dir/$value", $name, $domain);
		}
	}
}

function file_preg_replace($ori, $new, $file) {
	$FileContent = file_get_contents($file);
	$NewContent = preg_replace("@".$ori."@i", $new, $FileContent);
	file_put_contents($file, $NewContent);
}
?>
